/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.sound.Sound;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Gauge;

public class Audio {
    private Sound levelUp;
    private Sound playerDown;
    private Sound shipDown;
    private Sound playerShot;
    private static Audio instance;

    private Audio() {
        System.out.println("audio constructor");
    }

    public static Audio getAudio() {
        try {
            if (instance == null) {
                instance = new Audio();
            }
            return instance;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void init(Gauge gauge) throws IOException {
        try {
            System.out.println("starting load sounds");
            byte[] byArray = new byte[20000];
            InputStream inputStream = this.getClass().getResourceAsStream("/0.wav");
            inputStream.read(byArray);
            this.levelUp = new Sound(byArray, 5);
            this.levelUp.init(byArray, 5);
            this.incrementGauge(gauge);
            System.out.println("levelUp loaded");
            byArray = new byte[20000];
            inputStream = this.getClass().getResourceAsStream("/1.wav");
            inputStream.read(byArray);
            this.playerDown = new Sound(byArray, 5);
            this.playerDown.init(byArray, 5);
            this.incrementGauge(gauge);
            System.out.println("playerDown loaded");
            byArray = new byte[20000];
            inputStream = this.getClass().getResourceAsStream("/2.wav");
            inputStream.read(byArray);
            this.shipDown = new Sound(byArray, 5);
            this.shipDown.init(byArray, 5);
            this.incrementGauge(gauge);
            System.out.println("shipDown loaded");
            byArray = new byte[20000];
            inputStream = this.getClass().getResourceAsStream("/3.wav");
            inputStream.read(byArray);
            this.playerShot = new Sound(byArray, 5);
            this.playerShot.init(byArray, 5);
            this.incrementGauge(gauge);
            System.out.println("playerShot loaded");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void play(int n) {
        try {
            this.stopAll();
            switch (n) {
                case 0: {
                    this.levelUp.play(1);
                    break;
                }
                case 1: {
                    this.playerDown.play(1);
                    break;
                }
                case 2: {
                    this.shipDown.play(1);
                    break;
                }
                case 3: {
                    this.playerShot.play(1);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopAll() {
        try {
            if (this.levelUp.getState() == 0) {
                this.levelUp.stop();
            }
            if (this.playerDown.getState() == 0) {
                this.playerDown.stop();
            }
            if (this.shipDown.getState() == 0) {
                this.shipDown.stop();
            }
            if (this.playerShot.getState() == 0) {
                this.playerShot.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void incrementGauge(Gauge gauge) {
        try {
            System.gc();
            if (gauge != null) {
                int n = gauge.getValue();
                gauge.setValue(++n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

