/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BattleField
extends FullCanvas {
    private Engine engine;
    private CoastalForce parent;
    private Media media = Media.getMedia();
    private boolean showScript;
    public static final int JOYSTICK_LEFT = -3;
    public static final int JOYSTICK_RIGHT = -4;
    public static final int JOYSTICK_FIRE = -5;
    public static final int NAVY_LEFT = -6;
    public static final int NAVY_RIGHT = -7;
    private boolean showBullets;
    private boolean showNoAmmo;

    BattleField(CoastalForce coastalForce) throws IOException {
        this.parent = coastalForce;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    protected void keyRepeated(int n) {
        this.keyPressed(n);
    }

    protected void keyPressed(int n) {
        try {
            System.gc();
            if (n == 42) {
                boolean bl = this.showBullets = !this.showBullets;
            }
            if (n == -6 || n == -7) {
                this.parent.setPausedByPlayer(true);
                this.parent.pauseApp();
                return;
            }
            if (this.engine != null) {
                this.engine.processAction(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        try {
            Sprite sprite;
            if (this.engine == null) {
                return;
            }
            this.engine.getBackground().paint(graphics);
            Fleet fleet = this.engine.getShore();
            int n = 0;
            while (n < fleet.size()) {
                sprite = (Sprite)fleet.elementAt(n);
                sprite.paint(graphics);
                ++n;
            }
            this.engine.getSelection().paint(graphics);
            fleet = this.engine.getPlayerBombs();
            n = 0;
            while (n < fleet.size()) {
                sprite = (Sprite)fleet.elementAt(n);
                sprite.paint(graphics);
                ++n;
            }
            fleet = this.engine.getShips();
            n = 0;
            while (n < fleet.size()) {
                sprite = (Sprite)fleet.elementAt(n);
                sprite.paint(graphics);
                ++n;
            }
            fleet = this.engine.getBooms();
            n = 0;
            while (n < fleet.size()) {
                sprite = (Sprite)fleet.elementAt(n);
                sprite.paint(graphics);
                ++n;
            }
            fleet = this.engine.getCannons();
            n = 0;
            while (n < fleet.size()) {
                sprite = (Sprite)fleet.elementAt(n);
                if (sprite != null) {
                    sprite.paint(graphics);
                }
                ++n;
            }
            Image image = this.media.getDigits()[11];
            graphics.setClip(3, 2, image.getWidth(), image.getHeight());
            graphics.drawImage(image, 3, 2, 20);
            int n2 = image.getWidth() + 5;
            String string = Integer.toString(this.engine.getScores().getScore());
            this.paintDigits(graphics, n2, string, 20);
            n2 = 5;
            if (!this.showBullets) {
                string = Integer.toString(this.engine.getScores().getLevel());
                n2 = this.paintDigits(graphics, n2, string, 24) + 5;
                image = this.media.getDigits()[10];
            } else {
                string = Integer.toString(this.engine.getScores().getBullets());
                n2 = this.paintDigits(graphics, n2, string, 24) + 5;
                image = this.media.getDigits()[12];
            }
            graphics.setClip(this.getWidth() - n2 - image.getWidth(), 2, image.getWidth(), image.getHeight());
            graphics.drawImage(image, this.getWidth() - n2, 2, 24);
            if (this.showNoAmmo) {
                graphics.setClip(this.getWidth() / 2 - this.media.getMisc()[2].getWidth() / 2, this.media.getBackgrounds()[0].getHeight() / 2 - this.media.getMisc()[2].getHeight() / 2, this.media.getMisc()[2].getWidth(), this.media.getMisc()[2].getHeight());
                graphics.drawImage(this.media.getMisc()[2], this.getWidth() / 2, this.media.getBackgrounds()[0].getHeight() / 2, 3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int paintDigits(Graphics graphics, int n, String string, int n2) {
        try {
            if (n2 == 20) {
                int n3 = 0;
                while (n3 < string.length()) {
                    Image image = this.media.getDigits()[string.charAt(n3) - 48];
                    graphics.setClip(n, 4, image.getWidth(), image.getHeight());
                    graphics.drawImage(image, n, 4, n2);
                    n += image.getWidth();
                    ++n3;
                }
            } else {
                int n4 = string.length() - 1;
                while (n4 >= 0) {
                    Image image = this.media.getDigits()[string.charAt(n4) - 48];
                    graphics.setClip(this.getWidth() - n - image.getWidth(), 4, image.getWidth(), image.getHeight());
                    graphics.drawImage(image, this.getWidth() - n, 4, n2);
                    n += image.getWidth();
                    --n4;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    protected void hideNotify() {
        try {
            this.media.stopAll();
            if (!this.engine.isStopped()) {
                if (this.isShowScript()) {
                    this.engine.stop();
                } else {
                    this.parent.pauseApp();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showNotify() {
        try {
            this.setShowScript(false);
            try {
                this.parent.start();
            }
            catch (IOException iOException) {
                this.parent.proccessAlerts(null, iOException.getMessage(), (Displayable)this, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CoastalForce getParent() {
        return this.parent;
    }

    public void setParent(CoastalForce coastalForce) {
        this.parent = coastalForce;
    }

    public boolean isShowScript() {
        return this.showScript;
    }

    public void setShowScript(boolean bl) {
        this.showScript = bl;
    }

    public boolean isShowBullets() {
        return this.showBullets;
    }

    public void setShowBullets(boolean bl) {
        this.showBullets = bl;
    }

    public boolean isShowNoAmmo() {
        return this.showNoAmmo;
    }

    public void setShowNoAmmo(boolean bl) {
        this.showNoAmmo = bl;
    }
}

