/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStoreException;

public class CoastalForce
extends MIDlet {
    public static final boolean DEBUG = false;
    private boolean pausedByPlayer = false;
    private static boolean sound = true;
    private String[] mainMenuItems = new String[]{"New game", "High scores", "Turn sounds off", "Exit", "Help", "About"};
    private final String version = this.getAppProperty("MIDlet-Version");
    private final String ABOUT_TEXT = this.getAppProperty("MIDlet-Name") + ", version " + this.version + "\nCopyright 2003 Zindell Technologies, Ltd. All rights reserved. Developed by " + this.getAppProperty("MIDlet-Vendor") + " " + this.getAppProperty("MIDlet-Info-URL") + "\nSoftware is provided \"AS IS\" without warranty of any kind. In no event, shall we be liable for any claim, damages or other liability.";
    private final String HELP_TEXT;
    private final String CONGRATS_PREFIX;
    private final String CONGRATS_SUFIX;
    private int counter;
    public static final int MAX_COUNT = 65;
    private Media media;
    private Display display;
    private Gauge loadingGauge;
    private Form loadingForm;
    private Scores scores;
    private List mainMenu;
    private StringItem congratsItem;
    private TextField nameField;
    private CommandListener act;
    private Engine engine;
    private BattleField screen;
    private Form helpForm;
    private Form aboutForm;
    private Form highScoresForm;
    private Form enterNameForm;
    private Command back;
    private Command clear;
    private Command store;

    public CoastalForce() {
        this.HELP_TEXT = "Prevent the enemy ships from reaching the shore and destroying your cannons. Press the number of the cannon to fire on the ships. Alternatively you can move the joystick right and left to select cannon and press it to fire. Please note that you have a limited number of bullets for each level. Press '*' to switch between bullets and level display. Press the left selection button to pause the game. For further assistance, please send us an email at CoastalForce@jacado.com";
        this.CONGRATS_PREFIX = "Congratulations! You received ";
        this.CONGRATS_SUFIX = " points and entered the TOP FIVE!";
    }

    public void startApp() {
        try {
            if (this.display == null) {
                this.loadingForm = new Form("Loading");
                this.loadingGauge = new Gauge("Please wait", false, 65, this.counter);
                this.loadingForm.append((Item)this.loadingGauge);
                this.display = Display.getDisplay((MIDlet)this);
                this.display.setCurrent((Displayable)this.loadingForm);
                new Init().start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() throws IOException {
        try {
            if (!this.engine.isStopped()) {
                return;
            }
            this.mainMenu.setCommandListener(null);
            this.engine.start();
            this.display.setCurrent((Displayable)this.screen);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseApp() {
        try {
            this.engine.stop();
            this.mainMenu.setCommandListener(this.act);
            if (!this.mainMenu.getString(0).equals("Continue")) {
                this.mainMenu.insert(0, "Continue", null);
                this.mainMenu.setSelectedIndex(0, true);
            }
            this.display.setCurrent((Displayable)this.mainMenu);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exit() {
        try {
            this.notifyDestroyed();
            this.destroyApp(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroyApp(boolean bl) {
        this.engine.stop();
    }

    public void incrementGauge() {
        try {
            System.gc();
            this.counter = this.loadingGauge.getValue();
            ++this.counter;
            this.loadingGauge.setValue(this.counter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showScores() {
        this.highScoresForm = new Form("High scores");
        this.highScoresForm.addCommand(this.back);
        this.highScoresForm.addCommand(this.clear);
        this.highScoresForm.setCommandListener(this.act);
        if (!this.scores.isEmpty()) {
            int n = 0;
            while (n < this.scores.getNames().length) {
                int n2 = this.scores.getHighScores()[n];
                String string = String.valueOf(n2) + " - ";
                if (n2 >= 100 && n2 < 1000) {
                    string = "0" + string;
                }
                if (n2 >= 10 && n2 < 100) {
                    string = "00" + string;
                }
                if (n2 < 10) {
                    string = "000" + string;
                }
                this.highScoresForm.append((Item)new StringItem(null, string + this.scores.getNames()[n] + "\n"));
                ++n;
            }
        } else {
            this.highScoresForm.append("No scores yet.");
        }
        this.display.setCurrent((Displayable)this.highScoresForm);
    }

    public void proccessAlerts(String string, String string2, Displayable displayable, boolean bl) {
        Alert alert = null;
        if (bl) {
            if (string == null) {
                string = "ERROR";
            }
            alert = new Alert(string, string2, null, AlertType.ERROR);
        } else {
            alert = new Alert(string, string2, null, AlertType.CONFIRMATION);
        }
        alert.setTimeout(-2);
        this.display.setCurrent(alert, displayable);
    }

    public boolean isPausedByPlayer() {
        return this.pausedByPlayer;
    }

    public void setPausedByPlayer(boolean bl) {
        this.pausedByPlayer = bl;
    }

    public void proccessScore() {
        this.mainMenu.setCommandListener(this.act);
        List list = this.mainMenu;
        if (this.scores.getScore() > 0 && (this.scores.getHighScores().length < 5 || this.scores.getScore() > this.scores.getHighScores()[4])) {
            this.congratsItem.setText("Congratulations! You received " + this.scores.getScore() + " points and entered the TOP FIVE!");
            list = this.enterNameForm;
        }
        this.proccessAlerts("Game over!", "Your score is " + this.scores.getScore() + " points!", (Displayable)list, false);
    }

    public static boolean isSound() {
        return sound;
    }

    public Display getDisplay() {
        return this.display;
    }

    private class Init
    extends Thread {
        private Init() {
        }

        public void run() {
            try {
                CoastalForce.this.media = Media.getMedia(CoastalForce.this.loadingGauge);
                this.initMIDlet();
                new SplashCanvas(CoastalForce.this.display, (Displayable)CoastalForce.this.mainMenu, CoastalForce.this.media.getMisc()[0]);
            }
            catch (Exception exception) {
                Scores.clear();
                Form form = new Form("ERROR");
                form.append("Unrecoverable error during initialization. Please try to run the game again. If the error persists, please contact us at CoastalForce@jacado.com");
                form.addCommand(new Command("Exit", 7, 5));
                form.setCommandListener(new CommandListener(){

                    public void commandAction(Command command, Displayable displayable) {
                        CoastalForce.this.exit();
                    }
                });
                CoastalForce.this.proccessAlerts(null, exception.getMessage(), (Displayable)form, true);
            }
        }

        public void initMIDlet() throws IOException, RecordStoreException {
            CoastalForce.this.scores = Scores.getScores();
            CoastalForce.this.incrementGauge();
            CoastalForce.this.screen = new BattleField(CoastalForce.this);
            CoastalForce.this.engine = Engine.getEngine(CoastalForce.this.screen);
            CoastalForce.this.act = new Act();
            CoastalForce.this.back = new Command("Back", 2, 1);
            CoastalForce.this.clear = new Command("Clear", 4, 1);
            CoastalForce.this.store = new Command("Store", 4, 1);
            CoastalForce.this.incrementGauge();
            CoastalForce.this.congratsItem = new StringItem(null, null);
            CoastalForce.this.nameField = new TextField("Enter your name", null, 20, 0);
            CoastalForce.this.mainMenu = new List("CoastalForce", 3, CoastalForce.this.mainMenuItems, null);
            CoastalForce.this.mainMenu.setCommandListener(CoastalForce.this.act);
            CoastalForce.this.helpForm = new Form("Help");
            CoastalForce.this.helpForm.append("Prevent the enemy ships from reaching the shore and destroying your cannons. Press the number of the cannon to fire on the ships. Alternatively you can move the joystick right and left to select cannon and press it to fire. Please note that you have a limited number of bullets for each level. Press '*' to switch between bullets and level display. Press the left selection button to pause the game. For further assistance, please send us an email at CoastalForce@jacado.com");
            CoastalForce.this.helpForm.addCommand(CoastalForce.this.back);
            CoastalForce.this.helpForm.setCommandListener(CoastalForce.this.act);
            CoastalForce.this.aboutForm = new Form("About");
            CoastalForce.this.aboutForm.append(CoastalForce.this.ABOUT_TEXT);
            CoastalForce.this.aboutForm.addCommand(CoastalForce.this.back);
            CoastalForce.this.aboutForm.setCommandListener(CoastalForce.this.act);
            CoastalForce.this.enterNameForm = new Form("Well done!");
            CoastalForce.this.enterNameForm.addCommand(CoastalForce.this.store);
            CoastalForce.this.enterNameForm.setCommandListener(CoastalForce.this.act);
            CoastalForce.this.enterNameForm.append((Item)CoastalForce.this.congratsItem);
            CoastalForce.this.enterNameForm.append((Item)CoastalForce.this.nameField);
        }
    }

    private class Act
    implements CommandListener {
        private Act() {
        }

        public void commandAction(Command command, Displayable displayable) {
            System.gc();
            if (command == List.SELECT_COMMAND) {
                int n = CoastalForce.this.mainMenu.getSelectedIndex();
                if (CoastalForce.this.mainMenu.getString(n).equals("Continue")) {
                    CoastalForce.this.mainMenu.delete(0);
                    CoastalForce.this.mainMenu.setCommandListener(null);
                    CoastalForce.this.pausedByPlayer = false;
                    CoastalForce.this.display.setCurrent((Displayable)CoastalForce.this.screen);
                    return;
                }
                if (CoastalForce.this.mainMenu.getString(n).equals(CoastalForce.this.mainMenuItems[0])) {
                    if (CoastalForce.this.mainMenu.getString(0).equals("Continue")) {
                        CoastalForce.this.mainMenu.delete(0);
                    }
                    try {
                        if (CoastalForce.this.engine != null) {
                            CoastalForce.this.engine.stop();
                        }
                        CoastalForce.this.engine.init();
                        CoastalForce.this.start();
                    }
                    catch (IOException iOException) {
                        CoastalForce.this.proccessAlerts(null, iOException.getMessage(), (Displayable)CoastalForce.this.mainMenu, true);
                    }
                    return;
                }
                if (CoastalForce.this.mainMenu.getString(n).equals(CoastalForce.this.mainMenuItems[1])) {
                    CoastalForce.this.showScores();
                    return;
                }
                if (CoastalForce.this.mainMenu.getString(n).equals(CoastalForce.this.mainMenuItems[3])) {
                    CoastalForce.this.exit();
                    return;
                }
                if (CoastalForce.this.mainMenu.getString(n).equals(CoastalForce.this.mainMenuItems[4])) {
                    CoastalForce.this.display.setCurrent((Displayable)CoastalForce.this.helpForm);
                    return;
                }
                if (CoastalForce.this.mainMenu.getString(n).equals(CoastalForce.this.mainMenuItems[5])) {
                    CoastalForce.this.display.setCurrent((Displayable)CoastalForce.this.aboutForm);
                    return;
                }
                if (CoastalForce.this.mainMenu.getString(n).equals(CoastalForce.this.mainMenuItems[2]) || CoastalForce.this.mainMenu.getString(n).equals("Turn sounds on")) {
                    String string = "Turn sounds ";
                    string = sound ? string + "on" : string + "off";
                    CoastalForce.this.mainMenu.set(n, string, null);
                    sound = !sound;
                    return;
                }
                return;
            }
            if (command == CoastalForce.this.back) {
                CoastalForce.this.display.setCurrent((Displayable)CoastalForce.this.mainMenu);
                return;
            }
            if (command == CoastalForce.this.clear) {
                Scores.clear();
                CoastalForce.this.proccessAlerts(null, "High scores have been cleared.", (Displayable)CoastalForce.this.mainMenu, false);
                return;
            }
            if (command == CoastalForce.this.store) {
                try {
                    CoastalForce.this.scores.insertScore(CoastalForce.this.nameField.getString());
                }
                catch (RecordStoreException recordStoreException) {
                    CoastalForce.this.proccessAlerts(null, recordStoreException.getMessage(), (Displayable)CoastalForce.this.mainMenu, true);
                }
                catch (IOException iOException) {
                    CoastalForce.this.proccessAlerts(null, iOException.getMessage(), (Displayable)CoastalForce.this.mainMenu, true);
                }
                CoastalForce.this.showScores();
                return;
            }
        }
    }
}

