/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStoreException;

public class Engine
implements Runnable {
    private int shipsCount;
    public static final int SHIPS_ADDITION = 1;
    private boolean requestIncreaseLevel;
    private Fleet ships;
    private Fleet playerBombs;
    private Fleet booms;
    private Fleet cannons;
    private BattleField screen;
    private Sprite background;
    private Scores scores;
    private static Random rnd;
    private Vector tmp;
    private long last;
    private boolean stopped = true;
    private Media media;
    private int idleCounter;
    private Fleet shore;
    private static Engine instance;
    private int[] tickState;
    private Sprite selection;
    private int selected;
    private int shipsEggCount;
    private int bulletsEggCount;

    private Engine(BattleField battleField) throws IOException, RecordStoreException {
        try {
            this.screen = battleField;
            battleField.setEngine(this);
            this.scores = Scores.getScores();
            rnd = new Random();
            this.media = Media.getMedia();
            this.tmp = new Vector();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Engine getEngine(BattleField battleField) throws IOException, RecordStoreException {
        try {
            if (instance == null) {
                instance = new Engine(battleField);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return instance;
    }

    public static Engine getEngine() {
        if (instance == null) {
            throw new IllegalArgumentException("engine not created");
        }
        return instance;
    }

    public void init() throws IOException {
        try {
            Object object;
            this.scores.reset();
            this.screen.setShowNoAmmo(false);
            this.screen.setShowBullets(false);
            this.background = new Sprite(this.media.getBackgrounds()[0].getWidth() / 2, 0, this.media.getBackgrounds(), "sea");
            int n = 0;
            this.shore = new Fleet();
            int n2 = 0;
            while (n2 < this.media.getShore().length) {
                object = this.media.getShore()[n2];
                Sprite sprite = new Sprite(n + object.getWidth() / 2, this.screen.getHeight() - object.getHeight(), new Image[]{object}, "shore #" + n2);
                this.shore.addSprite(sprite);
                n += object.getWidth();
                ++n2;
            }
            this.selection = new Sprite(0, this.screen.getHeight() - 51, new Image[]{this.media.getMisc()[1]}, "selection");
            this.cannons = new Fleet();
            n2 = 0;
            while (n2 < 6) {
                object = new Sprite(this.screen.getWidth() / 12 + n2 * this.screen.getWidth() / 6, this.screen.getHeight() - 44, this.media.getCannon(), "cannon #" + n2);
                this.cannons.addSprite((Sprite)object);
                if (n2 == 2) {
                    this.selected = n2;
                    this.selection.setX(((Sprite)object).getX());
                }
                this.tickState = new int[6];
                ++n2;
            }
            this.initShips();
            this.booms = new Fleet();
            this.booms.setHorizontalStep(0);
            this.booms.setVerticalStep(0);
            this.booms.setBottomBoundary(this.screen.getHeight());
            this.playerBombs = new Fleet();
            this.playerBombs.setHorizontalStep(0);
            this.playerBombs.setVerticalStep(-4);
            this.playerBombs.setBottomBoundary(this.screen.getHeight());
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initShips() throws IOException {
        try {
            this.ships = new Fleet();
            this.ships.setBottomBoundary(this.background.getHeight());
            int n = 0;
            while (n < this.scores.getLevel() + 1) {
                boolean bl;
                Fleet fleet = this.cannons.removeNulls();
                Sprite sprite = (Sprite)fleet.elementAt(Engine.throwDice(0, fleet.size()));
                boolean bl2 = bl = Engine.throwDice(0, 2) == 0;
                if (this.cannons.indexOf(sprite) == 0) {
                    bl = false;
                }
                if (this.cannons.indexOf(sprite) == 5) {
                    bl = true;
                }
                int n2 = n * this.media.getShips()[0].getHeight() * -1;
                int n3 = sprite.getX() + (this.media.getBackgrounds()[0].getHeight() - this.media.getShips()[0].getHeight() - 2 + n * this.media.getShips()[0].getHeight()) / 2;
                int n4 = -1;
                Image[] imageArray = new Image[]{this.media.getShips()[0], this.media.getShips()[1]};
                if (bl) {
                    n3 = sprite.getX() - (this.media.getBackgrounds()[0].getHeight() - this.media.getShips()[0].getHeight() - 2 + n * this.media.getShips()[0].getHeight()) / 2;
                    n4 = 1;
                    imageArray[0] = this.media.getShips()[2];
                    imageArray[1] = this.media.getShips()[3];
                }
                Sprite sprite2 = new Sprite(n3, n2, n4, 2, imageArray, String.valueOf(n));
                if (bl) {
                    sprite2.setLeftBoundary(Integer.MIN_VALUE);
                    sprite2.setRightBoundary(this.background.getWidth());
                } else {
                    sprite2.setLeftBoundary(0);
                    sprite2.setRightBoundary(Integer.MAX_VALUE);
                }
                this.ships.addSprite(sprite2);
                ++this.shipsCount;
                this.requestIncreaseLevel = false;
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Fleet getShips() {
        return this.ships;
    }

    public Fleet getPlayerBombs() {
        return this.playerBombs;
    }

    public Fleet getBooms() {
        return this.booms;
    }

    public Scores getScores() {
        return this.scores;
    }

    public void start() {
        try {
            Thread thread = new Thread(this);
            thread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public static int throwDice(int n, int n2) {
        if (n2 <= n) {
            throw new IllegalArgumentException("Max(" + n2 + ") not bigger than min(" + n + ")");
        }
        return (rnd.nextInt() >>> 1) % (n2 - n) + n;
    }

    public void run() {
        try {
            int n = 0;
            long l = 0L;
            this.stopped = false;
            while (!this.stopped) {
                int n2 = Math.min(250, (int)(250L - (System.currentTimeMillis() - l)));
                int n3 = Math.max(250, n2);
                try {
                    int n4 = this.scores.getLevel() * 5;
                    Thread.sleep(n3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                l = System.currentTimeMillis();
                this.ships.moveShips(this.shore, this.cannons, this.booms);
                this.booms.moveBooms();
                this.playerBombs.moveBombs(this.ships, this.booms, this.scores);
                this.tickBack();
                if (n++ % 5 == 0) {
                    this.background.tick();
                    this.background.move();
                }
                this.screen.repaint();
                this.screen.serviceRepaints();
                if (this.cannons.isNull()) {
                    ++this.idleCounter;
                    if (this.idleCounter != 6 || !this.cannons.isNull()) continue;
                    this.idleCounter = 0;
                    this.media.stopAll();
                    this.gameOver();
                    return;
                }
                if (!this.ships.isEmpty() && !this.ships.standsStill() || !this.booms.isEmpty()) continue;
                try {
                    this.increaseLevel();
                }
                catch (IOException iOException) {
                }
                catch (RecordStoreException recordStoreException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void increaseLevel() throws RecordStoreException, IOException {
        try {
            int n = this.scores.getLevel();
            ++this.idleCounter;
            if (this.idleCounter == 10 && !this.requestIncreaseLevel) {
                this.requestIncreaseLevel = true;
                this.idleCounter = 0;
                if (this.scores.getLevel() == 8) {
                    this.screen.setShowScript(true);
                    this.screen.getParent().getDisplay().setCurrent((Displayable)new Script(this.screen, 1));
                    this.requestIncreaseLevel = false;
                    this.stop();
                    return;
                }
                this.media.stopAll();
                if (this.scores.increaseLevel((this.scores.getLevel() + 1) * 3)) {
                    this.screen.setShowScript(true);
                    this.screen.getParent().getDisplay().setCurrent((Displayable)new Script(this.screen, 0));
                }
                if (n != this.scores.getLevel()) {
                    this.addCannon();
                    this.screen.setShowNoAmmo(false);
                    this.screen.setShowBullets(false);
                }
                this.initShips();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCannon() {
        try {
            Vector<Integer> vector = new Vector<Integer>();
            int n = 0;
            while (n < this.cannons.size()) {
                Sprite sprite = (Sprite)this.cannons.elementAt(n);
                if (sprite == null) {
                    vector.addElement(new Integer(n));
                }
                ++n;
            }
            if (vector.size() > 0) {
                int n2 = Engine.throwDice(0, vector.size());
                int n3 = (Integer)vector.elementAt(n2);
                this.cannons.setElementAt(new Sprite(this.screen.getWidth() / 12 + n3 * this.screen.getWidth() / 6, this.screen.getHeight() - 44, this.media.getCannon(), "cannon #" + n3), n3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void tickBack() {
        int n = 0;
        while (n < this.tickState.length) {
            if (this.tickState[n] == 4) {
                Sprite sprite = (Sprite)this.cannons.elementAt(n);
                if (sprite != null) {
                    sprite.tick();
                }
                this.tickState[n] = 0;
            } else if (this.tickState[n] != 0) {
                int n2 = n;
                this.tickState[n2] = this.tickState[n2] + 1;
            }
            ++n;
        }
    }

    public void gameOver() {
        this.stop();
        this.screen.getParent().proccessScore();
        System.out.println("ships " + this.shipsCount);
    }

    public void processAction(int n) {
        try {
            if (!this.stopped) {
                Sprite sprite;
                if (n >= 49 && n <= 54) {
                    int n2 = n - 49;
                    this.fire(n2);
                }
                if (n == -5) {
                    Enumeration enumeration = this.cannons.elements();
                    while (enumeration.hasMoreElements()) {
                        sprite = (Sprite)enumeration.nextElement();
                        if (!(sprite != null & sprite.getX() == this.selection.getX())) continue;
                        this.fire(this.cannons.indexOf(sprite));
                        return;
                    }
                }
                if (n == -4 || n == -3) {
                    this.moveSelection(n);
                }
                if (n == 48 && ++this.shipsEggCount % 4 == 0) {
                    Enumeration enumeration = this.ships.elements();
                    while (enumeration.hasMoreElements()) {
                        sprite = (Sprite)enumeration.nextElement();
                        this.ships.sunkShip(this.ships, this.booms, this.scores, sprite);
                    }
                }
                if (n == 35 && ++this.bulletsEggCount % 4 == 0) {
                    this.scores.setBulletsEgg(!this.scores.isBulletsEgg());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void fire(int n) {
        try {
            if (this.scores.getBullets() == 0) {
                this.screen.setShowNoAmmo(true);
                return;
            }
            boolean bl = false;
            Sprite sprite = (Sprite)this.cannons.elementAt(n);
            if (sprite != null) {
                Sprite sprite2;
                Enumeration enumeration = this.playerBombs.elements();
                while (enumeration.hasMoreElements()) {
                    sprite2 = (Sprite)enumeration.nextElement();
                    if (sprite2.getX() + 2 != sprite.getX()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    if (this.scores.fire()) {
                        this.screen.setShowBullets(true);
                    }
                    this.selected = n;
                    this.selection.setX(sprite.getX());
                    sprite2 = new Sprite(sprite.getX(), sprite.getY(), 5, 5, 0, String.valueOf(sprite.toString().charAt(sprite.toString().length() - 1)));
                    sprite2.setYStep(-4);
                    this.playerBombs.addSprite(sprite2);
                    if (CoastalForce.isSound()) {
                        this.media.play(3, true);
                    }
                    sprite.tick();
                    int n2 = n;
                    this.tickState[n2] = this.tickState[n2] + 1;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void moveSelection(int n) {
        try {
            switch (n) {
                case -3: {
                    if (this.selected == 0) {
                        return;
                    }
                    --this.selected;
                    break;
                }
                case -4: {
                    if (this.selected == 5) {
                        return;
                    }
                    ++this.selected;
                }
            }
            Sprite sprite = (Sprite)this.cannons.elementAt(this.selected);
            if (sprite == null) {
                this.moveSelection(n);
            } else {
                this.selection.setX(sprite.getX());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Fleet getCannons() {
        return this.cannons;
    }

    public void setCannons(Fleet fleet) {
        this.cannons = fleet;
    }

    public boolean isIdle() {
        return this.idleCounter != 0;
    }

    public Fleet getShore() {
        return this.shore;
    }

    public Sprite getBackground() {
        return this.background;
    }

    public Sprite getSelection() {
        return this.selection;
    }
}

