/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;

public class Fleet
extends Vector {
    private int left_edge;
    private int right_edge;
    private int bottom_edge;
    private int horizontalStep;
    private int direction;
    private int verticalStep;
    private Media media = Media.getMedia();
    private int i;

    public Fleet() throws IOException {
        this.left_edge = Integer.MAX_VALUE;
        this.right_edge = Integer.MIN_VALUE;
        this.bottom_edge = Integer.MIN_VALUE;
    }

    public void addSprite(Sprite sprite) {
        this.addElement(sprite);
    }

    public boolean removeSprite(Sprite sprite) {
        try {
            if (sprite.getX() - sprite.getWidth() / 2 == this.left_edge) {
                this.resync();
            }
            if (sprite.getX() + sprite.getWidth() / 2 == this.right_edge) {
                this.resync();
            }
            if (sprite.getY() + sprite.getHeight() == this.bottom_edge) {
                this.resync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.removeElement(sprite);
    }

    public void replaceSprite(Sprite sprite) {
        try {
            if (sprite != null) {
                if (sprite.getX() - sprite.getWidth() / 2 == this.left_edge) {
                    this.resync();
                }
                if (sprite.getX() + sprite.getWidth() / 2 == this.right_edge) {
                    this.resync();
                }
                if (sprite.getY() + sprite.getHeight() == this.bottom_edge) {
                    this.resync();
                }
                this.setElementAt(null, this.indexOf(sprite));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void moveShips(Fleet fleet, Fleet fleet2, Fleet fleet3) {
        try {
            Sprite sprite = null;
            int n = 0;
            while (n < this.size()) {
                sprite = (Sprite)this.elementAt(n);
                sprite.move();
                sprite.tick();
                this.checkEdges(sprite);
                Sprite sprite2 = fleet.intersect(sprite);
                if (sprite2 != null) {
                    Sprite sprite3 = (Sprite)fleet2.elementAt(fleet.indexOf(sprite2));
                    if (sprite3 != null) {
                        fleet2.replaceSprite(sprite3);
                        fleet3.addSprite(new Sprite(sprite3.getX(), sprite3.getY(), this.media.getBooms(), fleet3, "booms"));
                        if (CoastalForce.isSound()) {
                            this.media.play(1, true);
                        }
                    }
                    sprite.stop();
                } else {
                    sprite2 = this.intersect(sprite);
                    if (sprite2 != null && sprite2.standsStill()) {
                        sprite.stop();
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void moveBombs(Fleet fleet, Fleet fleet2, Scores scores) {
        try {
            Sprite sprite = null;
            int n = 0;
            while (n < this.size()) {
                sprite = (Sprite)this.elementAt(n);
                sprite.move();
                if (sprite.getY() <= 0) {
                    this.removeSprite(sprite);
                } else {
                    Sprite sprite2 = fleet.intersect(sprite);
                    if (sprite2 != null) {
                        this.removeSprite(sprite);
                        this.sunkShip(fleet, fleet2, scores, sprite2);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sunkShip(Fleet fleet, Fleet fleet2, Scores scores, Sprite sprite) {
        try {
            fleet2.addSprite(new Sprite(sprite.getX(), sprite.getY(), this.media.getBooms(), fleet2, "booms"));
            if (CoastalForce.isSound()) {
                this.media.play(2, true);
            }
            fleet.removeSprite(sprite);
            scores.add();
            scores.shipSunk();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void moveBooms() {
        try {
            Sprite sprite = null;
            int n = 0;
            while (n < this.size()) {
                sprite = (Sprite)this.elementAt(n);
                sprite.move();
                sprite.tick();
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Sprite intersect(Sprite sprite) {
        Sprite sprite2 = null;
        int n = 0;
        while (n < this.size()) {
            sprite2 = (Sprite)this.elementAt(n);
            if (sprite.intersects(sprite2)) {
                return sprite2;
            }
            ++n;
        }
        return null;
    }

    private void resync() {
        Sprite sprite = null;
        int n = 0;
        while (n < this.size()) {
            sprite = (Sprite)this.elementAt(n);
            if (sprite != null) {
                this.checkEdges(sprite);
            }
            ++n;
        }
    }

    private void checkEdges(Sprite sprite) {
        if (sprite.getX() + sprite.getWidth() / 2 < sprite.getLeftBoundary() || sprite.getX() - sprite.getWidth() / 2 > sprite.getRightBoundary()) {
            this.removeSprite(sprite);
        }
    }

    public void setBottomBoundary(int n) {
        Sprite sprite = null;
        int n2 = 0;
        while (n2 < this.size()) {
            sprite = (Sprite)this.elementAt(n2);
            if (sprite != null) {
                sprite.setBottomBoundary(n);
            }
            ++n2;
        }
    }

    public void setHorizontalStep(int n) {
        Sprite sprite = null;
        int n2 = 0;
        while (n2 < this.size()) {
            sprite = (Sprite)this.elementAt(n2);
            if (sprite != null) {
                sprite.setXStep(n);
            }
            ++n2;
        }
        this.horizontalStep = n;
        this.direction = n;
    }

    public void setVerticalStep(int n) {
        Sprite sprite = null;
        int n2 = 0;
        while (n2 < this.size()) {
            sprite = (Sprite)this.elementAt(n2);
            if (sprite != null) {
                sprite.setYStep(n);
            }
            ++n2;
        }
        this.verticalStep = n;
    }

    public boolean isNull() {
        int n = 0;
        while (n < this.size()) {
            if (this.elementAt(n) != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean standsStill() {
        Sprite sprite = null;
        int n = 0;
        while (n < this.size()) {
            sprite = (Sprite)this.elementAt(n);
            if (sprite != null && !sprite.standsStill()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Fleet removeNulls() {
        Fleet fleet = null;
        try {
            fleet = new Fleet();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Sprite sprite = null;
        int n = 0;
        while (n < this.size()) {
            sprite = (Sprite)this.elementAt(n);
            if (sprite != null) {
                fleet.addSprite(sprite);
            }
            ++n;
        }
        return fleet;
    }
}

