/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Image;

public class Media {
    private Image[] misc;
    private Image[] backgrounds;
    private Image[] ships;
    private Image[] booms;
    private Image[] digits;
    private Audio audio;
    private Image[] cannon;
    private Image[] shore;
    private Image[] ranks;
    private Image[] medals;
    private Image[] scriptDigits;
    private Image[] awards;
    private Image[] statuses;
    private Image script;
    public static final int SPLASH = 0;
    public static final int SELECTION = 1;
    public static final int NO_AMMO = 2;
    public static final int POINTS = 11;
    public static final int LEVEL = 10;
    public static final int BULLETS = 12;
    public static final int LEVEL_UP = 20;
    public static final int PLAYER_DOWN = 21;
    public static final int SHIP_DOWN = 22;
    public static final int PLAYER_SHOT = 23;
    private static Media instance;

    public static Media getMedia() throws IOException {
        return Media.getMedia(null);
    }

    public static Media getMedia(Gauge gauge) throws IOException {
        if (instance == null) {
            instance = new Media(gauge);
        }
        return instance;
    }

    private Media(Gauge gauge) throws IOException {
        this.loadMainGraphics(gauge);
        this.loadScriptGraphics(gauge);
        this.audio = Audio.getAudio();
        System.out.println("calling init");
        this.audio.init(gauge);
    }

    private void loadMainGraphics(Gauge gauge) throws IOException {
        this.misc = new Image[3];
        int n = 0;
        while (n < this.misc.length) {
            this.misc[n] = Image.createImage((String)("/misc" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
        this.backgrounds = new Image[2];
        n = 0;
        while (n < this.backgrounds.length) {
            this.backgrounds[n] = Image.createImage((String)("/bgr" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
        this.ships = new Image[4];
        n = 0;
        while (n < this.ships.length) {
            this.ships[n] = Image.createImage((String)("/ship" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
        this.booms = new Image[5];
        n = 0;
        while (n < this.booms.length) {
            this.booms[n] = Image.createImage((String)("/boom" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
        this.shore = new Image[6];
        n = 0;
        while (n < this.shore.length) {
            this.shore[n] = Image.createImage((String)("/shore" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
        this.cannon = new Image[2];
        n = 0;
        while (n < this.cannon.length) {
            this.cannon[n] = Image.createImage((String)("/cannon" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
        this.digits = new Image[13];
        n = 0;
        while (n < this.digits.length) {
            this.digits[n] = Image.createImage((String)("/" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
    }

    private void loadScriptGraphics(Gauge gauge) throws IOException {
        this.ranks = new Image[4];
        int n = 0;
        while (n < this.ranks.length) {
            this.ranks[n] = Image.createImage((String)("/script/rank" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
        this.medals = new Image[4];
        n = 0;
        while (n < this.medals.length) {
            this.medals[n] = Image.createImage((String)("/script/medal" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
        this.scriptDigits = new Image[10];
        n = 0;
        while (n < this.scriptDigits.length) {
            this.scriptDigits[n] = Image.createImage((String)("/script/" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
        this.awards = new Image[4];
        n = 0;
        while (n < this.awards.length) {
            this.awards[n] = Image.createImage((String)("/script/award" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
        this.script = Image.createImage((String)"/script/script.png");
        this.incrementGauge(gauge);
        this.statuses = new Image[2];
        n = 0;
        while (n < this.statuses.length) {
            this.statuses[n] = Image.createImage((String)("/script/status" + n + ".png"));
            this.incrementGauge(gauge);
            ++n;
        }
    }

    public void incrementGauge(Gauge gauge) {
        System.gc();
        if (gauge != null) {
            int n = gauge.getValue();
            gauge.setValue(++n);
        }
    }

    public Image[] getBooms() {
        return this.booms;
    }

    public Image[] getMisc() {
        return this.misc;
    }

    public Image[] getShips() {
        return this.ships;
    }

    public Image[] getBackgrounds() {
        return this.backgrounds;
    }

    public Image[] getDigits() {
        return this.digits;
    }

    public void play(int n, boolean bl) {
        try {
            this.audio.play(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopAll() {
        try {
            this.audio.stopAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image[] getCannon() {
        return this.cannon;
    }

    public Image[] getShore() {
        return this.shore;
    }

    public Image[] getAwards() {
        return this.awards;
    }

    public Image[] getMedals() {
        return this.medals;
    }

    public Image[] getRanks() {
        return this.ranks;
    }

    public Image getScript() {
        return this.script;
    }

    public Image[] getScriptDigits() {
        return this.scriptDigits;
    }

    public Image[] getStatuses() {
        return this.statuses;
    }
}

