/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class Scores {
    private int score;
    private int level;
    private int highScore;
    private int highScoreID;
    private RecordStore recordStore = null;
    private static Scores instance;
    private String[] names;
    private int[] highScores;
    private int rank;
    private int totalSunk;
    private int levelSunk;
    private int clearLevelCount;
    private int wave;
    private int bullets;
    private boolean bulletsEgg;
    public static final int WAVES_PER_LEVEL = 3;

    public static Scores getScores() throws RecordStoreException, IOException {
        if (instance == null) {
            instance = new Scores();
        }
        return instance;
    }

    private Scores() throws RecordStoreException, IOException {
        this.load();
    }

    public void reset() {
        this.score = 0;
        this.level = 1;
        this.rank = 0;
        this.clearLevelCount = 0;
        this.levelSunk = 0;
        this.totalSunk = 0;
        this.wave = 1;
        this.setBullets((this.getLevel() + 1) * 3 + 2);
    }

    public void add() {
        this.add(1);
    }

    public void add(int n) {
        this.score += n;
    }

    public int getScore() {
        return this.score;
    }

    public void load() throws RecordStoreException, IOException {
        byte[] byArray = null;
        this.recordStore = RecordStore.openRecordStore((String)"CoastalForceScores", (boolean)true);
        if (this.recordStore.getNumRecords() == 0) {
            this.names = new String[0];
            this.highScores = new int[0];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(0);
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            this.recordStore.addRecord(byArray, 0, byArray.length);
        } else {
            byArray = this.recordStore.getRecord(1);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            int n = dataInputStream.readInt();
            this.names = new String[n];
            this.highScores = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.names[n2] = dataInputStream.readUTF();
                this.highScores[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.close();
    }

    public void close() throws RecordStoreException {
        try {
            this.recordStore.closeRecordStore();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            // empty catch block
        }
    }

    public void save() throws RecordStoreException, IOException {
        byte[] byArray = null;
        this.recordStore = RecordStore.openRecordStore((String)"CoastalForceScores", (boolean)true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this.names.length);
        int n = 0;
        while (n < this.names.length) {
            dataOutputStream.writeUTF(this.names[n]);
            dataOutputStream.writeInt(this.highScores[n]);
            ++n;
        }
        byteArrayOutputStream.flush();
        byArray = byteArrayOutputStream.toByteArray();
        if (this.recordStore.getNumRecords() == 0) {
            this.recordStore.addRecord(byArray, 0, byArray.length);
        } else {
            this.recordStore.setRecord(1, byArray, 0, byArray.length);
        }
        this.close();
    }

    public int[] getHighScores() {
        return this.highScores;
    }

    public String[] getNames() {
        return this.names;
    }

    public static void clear() {
        try {
            Scores scores = null;
            try {
                scores = Scores.getScores();
                scores.close();
                scores.setHighScores(new int[0]);
                scores.setNames(new String[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            RecordStore.deleteRecordStore((String)"CoastalForceScores");
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void setHighScores(int[] nArray) {
        this.highScores = nArray;
    }

    public void setNames(String[] stringArray) {
        this.names = stringArray;
    }

    public boolean isEmpty() {
        return this.getNames().length == 0;
    }

    public void insertScore(String string) throws IOException, RecordStoreException {
        String[] stringArray = null;
        int[] nArray = null;
        if (this.isEmpty()) {
            stringArray = new String[]{string};
            nArray = new int[]{this.getScore()};
        } else {
            if (this.getNames().length == 5) {
                stringArray = new String[5];
                nArray = new int[5];
            } else {
                stringArray = new String[this.getNames().length + 1];
                nArray = new int[this.getHighScores().length + 1];
            }
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                if (!bl && n == this.getNames().length) {
                    stringArray[n] = string;
                    nArray[n] = this.getScore();
                    break;
                }
                if (!bl && this.getScore() > this.getHighScores()[n]) {
                    stringArray[n] = string;
                    nArray[n] = this.getScore();
                    bl = true;
                } else if (bl) {
                    stringArray[n] = this.getNames()[n - 1];
                    nArray[n] = this.getHighScores()[n - 1];
                } else {
                    stringArray[n] = this.getNames()[n];
                    nArray[n] = this.getHighScores()[n];
                }
                ++n;
            }
        }
        this.setNames(stringArray);
        this.setHighScores(nArray);
        this.save();
    }

    public int getLevel() {
        return this.level;
    }

    public boolean increaseLevel(int n) {
        if (this.wave == 3) {
            try {
                Media.getMedia().play(0, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.wave = 1;
            ++this.level;
            if (this.bulletsEgg) {
                this.setBullets(999);
            } else {
                this.setBullets((this.getLevel() + 1) * 3 + 2);
            }
            this.clearLevelCount = n == this.levelSunk ? ++this.clearLevelCount : 0;
            this.levelSunk = 0;
            if (this.clearLevelCount == 2) {
                ++this.rank;
                this.score += 50 * this.rank;
                this.clearLevelCount = 0;
                return true;
            }
            return false;
        }
        ++this.wave;
        return false;
    }

    public int getLevelSunk() {
        return this.levelSunk;
    }

    public int getRank() {
        return this.rank;
    }

    public int getTotalSunk() {
        return this.totalSunk;
    }

    public void shipSunk() {
        ++this.totalSunk;
        ++this.levelSunk;
    }

    public int getBullets() {
        return this.bullets;
    }

    public void setBullets(int n) {
        this.bullets = n;
    }

    public boolean fire() {
        if (this.getBullets() > 0) {
            this.setBullets(this.getBullets() - 1);
        }
        return this.getBullets() <= (this.level + 1) * 3 / 3;
    }

    public boolean isBulletsEgg() {
        return this.bulletsEgg;
    }

    public void setBulletsEgg(boolean bl) {
        this.bulletsEgg = bl;
        if (this.bulletsEgg) {
            this.setBullets(999);
        }
    }
}

