/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStoreException;

public class Script
extends FullCanvas {
    private BattleField parent;
    private Media media;
    private Timer timer;
    private Scores scores;
    private int status;
    private boolean allowDissmis;
    public static final int NEXT_RANK = 0;
    public static final int GAME_OVER = 1;

    public Script(BattleField battleField, int n) throws RecordStoreException, IOException {
        this.status = n;
        this.media = Media.getMedia();
        this.parent = battleField;
        this.timer = new Timer();
        this.scores = Scores.getScores();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.media.getScript(), 0, 0, 20);
        this.paintDigits(graphics, 66, 72, String.valueOf(this.scores.getTotalSunk()));
        graphics.drawImage(this.media.getStatuses()[this.status], 21, 43, 20);
        graphics.drawImage(this.media.getAwards()[this.scores.getRank()], 0, 0, 20);
        graphics.drawImage(this.media.getRanks()[this.scores.getRank()], 27, 145, 20);
        graphics.drawImage(this.media.getMedals()[this.scores.getRank()], 0, 0, 20);
    }

    public void paintDigits(Graphics graphics, int n, int n2, String string) {
        int n3 = n;
        int n4 = 0;
        while (n4 < string.length()) {
            Image image = this.media.getScriptDigits()[string.charAt(n4) - 48];
            graphics.drawImage(image, n3, n2, 20);
            n3 += image.getWidth() + 2;
            ++n4;
        }
    }

    protected void showNotify() {
        this.timer.schedule((TimerTask)new CountDown(), 7000L);
        this.timer.schedule((TimerTask)new DissmisAllower(), 2000L);
    }

    public BattleField getParent() {
        return this.parent;
    }

    public void setParent(BattleField battleField) {
        this.parent = battleField;
    }

    private void dismiss() {
        if (this.allowDissmis) {
            this.timer.cancel();
            if (this.status == 1) {
                this.parent.getParent().proccessScore();
            } else {
                this.parent.getParent().getDisplay().setCurrent((Displayable)this.parent);
            }
        }
    }

    protected void keyPressed(int n) {
        this.dismiss();
    }

    private class DissmisAllower
    extends TimerTask {
        private DissmisAllower() {
        }

        public void run() {
            Script.this.allowDissmis = true;
        }
    }

    private class CountDown
    extends TimerTask {
        private CountDown() {
        }

        public void run() {
            Script.this.dismiss();
        }
    }
}

