/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashCanvas
extends FullCanvas {
    private Timer timer = new Timer();
    private Image image;
    private int width;
    private int height;
    private int xCenter;
    private int yCenter;
    private int imageTop;
    private int imageBottom;
    private Font bigFont;
    private Font smallFont;
    private Displayable next;
    private Display display;
    private String productName;
    private String productVer;
    private boolean text = false;

    public SplashCanvas(Display display, Displayable displayable, Image image, String string, String string2) {
        this.productName = string;
        this.productVer = string2;
        this.display = display;
        this.next = displayable;
        this.image = image;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.bigFont = Font.getFont((int)0, (int)1, (int)16);
        this.smallFont = Font.getFont((int)0, (int)1, (int)0);
        this.xCenter = this.getWidth() / 2;
        this.yCenter = this.getHeight() / 2;
        this.imageTop = this.yCenter - image.getHeight() / 2;
        this.imageBottom = this.yCenter + image.getHeight() / 2;
        display.setCurrent((Displayable)this);
    }

    public SplashCanvas(Display display, Displayable displayable, Image image) {
        this.display = display;
        this.next = displayable;
        this.image = image;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.xCenter = this.getWidth() / 2;
        this.yCenter = this.getHeight() / 2;
        this.imageTop = this.yCenter - image.getHeight() / 2;
        this.imageBottom = this.yCenter + image.getHeight() / 2;
        display.setCurrent((Displayable)this);
    }

    protected void showNotify() {
        this.timer.schedule((TimerTask)new CountDown(), 3500L);
    }

    protected void keyPressed(int n) {
        this.dismiss();
    }

    protected void pointerPressed(int n, int n2) {
        this.dismiss();
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.drawImage(this.image, 0, 0, 20);
        if (this.text) {
            graphics.setColor(0, 0, 0);
            graphics.setFont(this.bigFont);
            graphics.drawString(this.productName, this.xCenter, this.imageTop + 25, 17);
            graphics.setColor(0, 0, 0);
            graphics.setFont(this.smallFont);
            graphics.drawString("ver " + this.productVer, this.xCenter, this.imageTop + 50, 17);
        }
    }

    private void dismiss() {
        this.timer.cancel();
        this.display.setCurrent(this.next);
    }

    private class CountDown
    extends TimerTask {
        private CountDown() {
        }

        public void run() {
            SplashCanvas.this.dismiss();
        }
    }
}

