/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite {
    private Image[] images;
    private Fleet fleet;
    private int x;
    private int y;
    private int height;
    private int width;
    private int index;
    private int color;
    private int xStep;
    private int yStep;
    private String name;
    private int leftBoundary;
    private int rightBoundary;
    private int bottomBoundary;

    public Sprite(String string) {
        this.name = string;
    }

    public Sprite(int n, int n2, int n3, int n4, int n5, String string) {
        this.translate(n - n3 / 2, n2);
        this.width = n3;
        this.height = n4;
        this.color = n5;
        this.name = string;
    }

    public Sprite(int n, int n2, Image[] imageArray, String string) {
        this(n, n2, imageArray, null, string);
    }

    public Sprite(int n, int n2, Image[] imageArray, Fleet fleet, String string) {
        this.images = imageArray;
        this.index = 0;
        this.translate(n, n2);
        this.width = imageArray[0].getWidth();
        this.height = imageArray[0].getHeight();
        this.fleet = fleet;
        this.name = string;
    }

    public Sprite(int n, int n2, int n3, int n4, Image[] imageArray, String string) {
        this.images = imageArray;
        this.index = 0;
        this.translate(n, n2);
        this.xStep = n3;
        this.yStep = n4;
        this.width = imageArray[0].getWidth();
        this.height = imageArray[0].getHeight();
        this.name = string;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void translate(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    public void move() {
        this.translate(this.getX() + this.xStep, this.getY() + this.yStep);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Image getImage() {
        if (this.images == null) {
            return null;
        }
        return this.images[this.index];
    }

    public void tick() {
        if (this.index + 1 == this.images.length) {
            if (this.fleet == null) {
                this.index = 0;
            } else {
                this.fleet.removeElement(this);
            }
        } else {
            ++this.index;
        }
    }

    public void paint(Graphics graphics) {
        if (this.images == null) {
            graphics.setClip(this.x, this.y, this.getWidth(), this.getHeight());
            graphics.setColor(0);
            graphics.fillArc(this.x, this.y, this.width, this.height, 0, 360);
        } else {
            graphics.setClip(this.x - this.getWidth() / 2, this.y, this.getWidth(), this.getHeight());
            graphics.drawImage(this.images[this.index], this.x, this.y, 17);
        }
    }

    public boolean intersects(Sprite sprite) {
        boolean bl = false;
        boolean bl2 = false;
        try {
            Point point = new Point(this.x - this.width / 2, this.y);
            Point point2 = new Point(this.x + this.width / 2, this.y);
            Point point3 = new Point(this.x - this.width / 2, this.y + this.height);
            Point point4 = new Point(this.x + this.width / 2, this.y + this.height);
            bl = sprite.contains(point) || sprite.contains(point2) || sprite.contains(point3) || sprite.contains(point4);
            point.set(sprite.x - sprite.width / 2, sprite.y);
            point2.set(sprite.x + sprite.width / 2, sprite.y);
            point3.set(sprite.x - sprite.width / 2, sprite.y + sprite.height);
            point4.set(sprite.x + sprite.width / 2, sprite.y + sprite.height);
            bl2 = this.contains(point) || this.contains(point2) || this.contains(point3) || this.contains(point4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl || bl2;
    }

    public boolean contains(Point point) {
        return point.x >= this.x - this.width / 2 && point.x <= this.x + this.width / 2 && point.y >= this.y && point.y <= this.y + this.height;
    }

    public int getXStep() {
        return this.xStep;
    }

    public int getYStep() {
        return this.yStep;
    }

    public void setXStep(int n) {
        this.xStep = n;
    }

    public void setYStep(int n) {
        this.yStep = n;
    }

    public String toString() {
        return this.name;
    }

    public boolean hasImages() {
        return this.images != null;
    }

    public boolean standsStill() {
        return this.xStep == 0 && this.yStep == 0;
    }

    public void setImages(Image[] imageArray) {
        this.images = imageArray;
    }

    public String getName() {
        return this.name;
    }

    public int getLeftBoundary() {
        return this.leftBoundary;
    }

    public int getRightBoundary() {
        return this.rightBoundary;
    }

    public void setLeftBoundary(int n) {
        this.leftBoundary = n;
    }

    public void setRightBoundary(int n) {
        this.rightBoundary = n;
    }

    public int getBottomBoundary() {
        return this.bottomBoundary;
    }

    public void setBottomBoundary(int n) {
        this.bottomBoundary = n;
    }

    public void stop() {
        this.setXStep(0);
        this.setYStep(0);
    }

    private class Point {
        public int x;
        public int y;

        public Point(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public void set(int n, int n2) {
            this.x = n;
            this.y = n2;
        }
    }
}

