/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class BugsCanvas
extends FullCanvas
implements Runnable {
    private final long MIN_MEMORY;
    private final int NUM_BUGS_TO_DIE;
    private final int NUM_BUGS_TO_NEW_STAGE;
    private final int INITIAL_DELAY;
    private int hideTimes;
    int screenWidth;
    int screenHeight;
    int width;
    int height;
    int moveRight;
    int moveDown;
    private int scoreStrHeight;
    private int imgHeight;
    private int imgWidth;
    private int bugsHeight;
    int catchX;
    int catchY;
    int expX;
    int expY;
    int diam = 16;
    int step = 8;
    private boolean doubleStep;
    private int repaintCounter;
    private int repaintDelay;
    private boolean million;
    private int missed;
    private int numBugsCaught;
    private int oneAfterAnother;
    private String bugsStr;
    private boolean showString;
    private int level;
    private int prevLevel;
    private int score;
    private int lives;
    private int stage;
    boolean exit;
    private Thread t = null;
    private int delay;
    private boolean goOn;
    private boolean goWait;
    private boolean firstTime;
    private boolean afterNewStage;
    private boolean bNewStageAlert;
    boolean newGame;
    boolean sound;
    private Font smallFont;
    private Font bigFont;
    private Font bugsFont;
    private Alert newStageAlert;
    private Alert gameOverAlert;
    private String resultStr;
    private String titleStr;
    Image[][] bugsImg;
    private Image backBelow;
    private Image backOver;
    BugsLocation[] locations;
    BugsEngine bugsEngine;
    ExplosionEngine explosionEngine;
    SoundsEngine soundsEngine;
    private BugzBuster midlet;

    BugsCanvas(BugzBuster bugzBuster) {
        this.MIN_MEMORY = 300000L;
        this.NUM_BUGS_TO_DIE = 10;
        this.NUM_BUGS_TO_NEW_STAGE = 50;
        this.INITIAL_DELAY = 0;
        this.midlet = bugzBuster;
        this.soundsEngine = new SoundsEngine();
        this.backBelow = this.midlet.backBelow;
        this.backOver = this.midlet.backOver;
        this.bugsImg = this.midlet.bugsImg;
        this.smallFont = Font.getFont((int)0, (int)1, (int)8);
        this.bigFont = Font.getFont((int)0, (int)1, (int)16);
        this.bugsFont = Font.getFont((int)0, (int)1, (int)0);
        this.scoreStrHeight = this.smallFont.getHeight() + 3;
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.newStageAlert = new Alert("New stage", this.resultStr, this.bugsImg[1][0], AlertType.INFO);
        this.gameOverAlert = new Alert("Game over", this.resultStr, this.bugsImg[1][0], AlertType.INFO);
        if (this.backBelow == null || this.backOver == null) {
            this.height = this.screenHeight - 20;
            this.width = this.screenWidth - 10;
            this.moveRight = (this.screenWidth - this.width) / 2;
            this.moveDown = 5;
        } else {
            this.height = this.screenHeight - 20;
            this.width = this.screenWidth;
            this.moveRight = 0;
            this.moveDown = 0;
        }
        this.sound = true;
        this.prevLevel = 1;
        this.exit = false;
        this.firstTime = true;
    }

    void init() {
        this.level = 1;
        if (this.bugsEngine == null) {
            this.bugsEngine = new BugsEngine(this);
        }
        this.explosionEngine = null;
        this.explosionEngine = new ExplosionEngine(this.midlet.expImg);
        this.catchX = this.moveRight + this.width / 2 - this.diam / 2;
        this.catchY = this.moveDown + this.height / 2 - this.diam / 2;
        this.delay = 0;
        this.repaintDelay = 3;
        this.repaintCounter = -1;
        if (this.firstTime) {
            this.firstTime = false;
            this.startAnimation();
        } else {
            this.newGame = true;
            this.resumeAnimation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Runtime.getRuntime().freeMemory() < 300000L) {
            System.gc();
        }
        while (this.goOn) {
            if (this.goWait) {
                try {
                    BugsCanvas bugsCanvas = this;
                    synchronized (bugsCanvas) {
                        this.wait();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++this.repaintCounter;
            this.explosionEngine.tick();
            if (this.repaintCounter >= this.repaintDelay) {
                this.repaintCounter = 0;
                this.bugsEngine.tick();
                this.checkIfGameIsOver();
            }
            this.repaint();
            this.serviceRepaints();
            try {
                Thread.sleep(this.delay);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void startAnimation() {
        if (Runtime.getRuntime().freeMemory() < 300000L) {
            System.gc();
        }
        this.goOn = true;
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
        }
        this.million = false;
        this.score = 0;
        this.lives = 3;
        this.stage = 1;
        this.missed = 0;
        this.numBugsCaught = 0;
        this.oneAfterAnother = 0;
        this.bugsEngine.init();
    }

    protected void hideNotify() {
        if (this.bNewStageAlert) {
            ++this.hideTimes;
        }
        if (!this.newStageAlert.isShown() && !this.gameOverAlert.isShown() && this.goOn && !this.goWait) {
            this.pauseAnimation();
            this.midlet.currentDisplayable = this.midlet.mainList;
            this.midlet.display.setCurrent(this.midlet.currentDisplayable);
        }
    }

    protected void showNotify() {
        if (this.bNewStageAlert && this.goWait && this.hideTimes % 2 == 1) {
            this.resumeAnimation();
            this.bNewStageAlert = false;
        }
    }

    void pauseAnimation() {
        this.goWait = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeAnimation() {
        if (Runtime.getRuntime().freeMemory() < 300000L) {
            System.gc();
        }
        this.goWait = false;
        BugsCanvas bugsCanvas = this;
        synchronized (bugsCanvas) {
            this.notifyAll();
        }
        if (this.newGame) {
            this.newGame = false;
            this.million = false;
            this.score = 0;
            this.lives = 3;
            this.stage = 1;
            this.missed = 0;
            this.numBugsCaught = 0;
            this.oneAfterAnother = 0;
            this.bugsEngine.init();
        }
    }

    void stopAnimation() {
        this.goOn = false;
        this.t = null;
    }

    public void paint(Graphics graphics) {
        int n = 0;
        if (this.backBelow == null) {
            graphics.setColor(6600827);
            graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        } else {
            graphics.drawImage(this.backBelow, 0, 0, 4 | 0x10);
        }
        this.locations = null;
        this.locations = this.bugsEngine.getLocations();
        n = 0;
        while (n < this.locations.length) {
            if (this.bugsImg[this.locations[n].img][this.locations[n].frame] != null) {
                if (this.locations[n].img == 0 || this.locations[n].img == 4) {
                    graphics.setColor(0, 0, 0);
                    int n2 = this.locations[n].x + this.bugsImg[this.locations[n].img][this.locations[n].frame].getWidth() / 2;
                    int n3 = this.locations[n].y + this.bugsImg[this.locations[n].img][this.locations[n].frame].getHeight() / 2;
                    graphics.drawLine(n2, 0, n2, n3);
                }
                graphics.drawImage(this.bugsImg[this.locations[n].img][this.locations[n].frame], this.locations[n].x, this.locations[n].y, 20);
            }
            ++n;
        }
        n = 0;
        while (n < 10) {
            if (this.explosionEngine.isExplosion(n) && this.explosionEngine.getImage(n) != null) {
                graphics.drawImage(this.explosionEngine.getImage(n), this.explosionEngine.getX(n), this.explosionEngine.getY(n), 4 | 0x10);
            }
            ++n;
        }
        if (this.backOver == null) {
            graphics.setColor(6600827);
            graphics.fillRect(0, 0, this.screenWidth, this.moveDown);
            graphics.fillRect(0, this.moveDown + this.height, this.screenWidth, this.screenHeight - this.moveDown - this.height);
            graphics.fillRect(0, 0, this.moveRight, this.screenHeight);
            graphics.fillRect(this.moveRight + this.width, 0, this.screenWidth - this.moveRight - this.width, this.screenHeight);
            graphics.setColor(0, 100, 0);
            graphics.drawRect(this.moveRight, this.moveDown, this.width, this.height);
        } else {
            graphics.drawImage(this.backOver, 0, 0, 4 | 0x10);
        }
        graphics.setColor(160, 0, 0);
        graphics.drawArc(this.catchX, this.catchY, this.diam, this.diam, 0, 360);
        graphics.drawArc(this.catchX + this.diam / 4, this.catchY + this.diam / 4, this.diam / 2, this.diam / 2, 0, 360);
        graphics.drawLine(this.catchX + this.diam / 2, this.catchY, this.catchX + this.diam / 2, this.catchY + this.diam / 4);
        graphics.drawLine(this.catchX + this.diam / 2, this.catchY + this.diam - this.diam / 4, this.catchX + this.diam / 2, this.catchY + this.diam);
        graphics.drawLine(this.catchX, this.catchY + this.diam / 2, this.catchX + this.diam / 4, this.catchY + this.diam / 2);
        graphics.drawLine(this.catchX + this.diam - this.diam / 4, this.catchY + this.diam / 2, this.catchX + this.diam, this.catchY + this.diam / 2);
        graphics.setFont(this.smallFont);
        graphics.setColor(0xFFCC00);
        graphics.drawString("stage:" + String.valueOf(this.stage), this.moveRight + 1, this.height + 7, 0x10 | 4);
        graphics.drawString(String.valueOf(this.score), this.screenWidth / 2, this.height + 7, 0x10 | 1);
        graphics.drawString("lives:" + String.valueOf(this.lives), this.moveRight + this.width - 1, this.height + 7, 0x10 | 8);
    }

    protected void keyRepeated(int n) {
        if (!(this.goWait || this.getGameAction(n) != 5 && this.getGameAction(n) != 2 && this.getGameAction(n) != 1 && this.getGameAction(n) != 6 && n != 49 && n != 51 && n != 55 && n != 57)) {
            this.doubleStep = true;
            this.keyPressed(n);
        }
    }

    protected synchronized void keyPressed(int n) {
        if (!this.goWait) {
            if (n == -6 || n == -7) {
                this.pauseAnimation();
                this.midlet.currentDisplayable = this.midlet.mainList;
                this.midlet.display.setCurrent(this.midlet.currentDisplayable);
            } else if (this.getGameAction(n) == 5) {
                if (this.catchX < this.moveRight + this.width - this.diam) {
                    if (this.doubleStep) {
                        this.catchX += 2 * this.step;
                        this.doubleStep = false;
                    } else {
                        this.catchX += this.step;
                    }
                    if (this.catchX > this.moveRight + this.width - this.diam) {
                        this.catchX = this.moveRight + this.width - this.diam - 1;
                    }
                }
            } else if (this.getGameAction(n) == 2) {
                if (this.catchX > this.moveRight) {
                    if (this.doubleStep) {
                        this.catchX -= 2 * this.step;
                        this.doubleStep = false;
                    } else {
                        this.catchX -= this.step;
                    }
                    if (this.catchX < this.moveRight) {
                        this.catchX = this.moveRight + 1;
                    }
                }
            } else if (this.getGameAction(n) == 1) {
                if (this.catchY > this.moveDown) {
                    if (this.doubleStep) {
                        this.catchY -= 2 * this.step;
                        this.doubleStep = false;
                    } else {
                        this.catchY -= this.step;
                    }
                    if (this.catchY < this.moveDown) {
                        this.catchY = this.moveDown + 1;
                    }
                }
            } else if (this.getGameAction(n) == 6) {
                if (this.catchY < this.moveDown + this.height - this.diam + 5) {
                    if (this.doubleStep) {
                        this.catchY += 2 * this.step;
                        this.doubleStep = false;
                    } else {
                        this.catchY += this.step;
                    }
                    if (this.catchY > this.moveDown + this.height - this.diam) {
                        this.catchY = this.moveDown + this.height - this.diam - 1;
                    }
                }
            } else if (this.getGameAction(n) == 8) {
                this.bugsEngine.check(this.catchX, this.catchY, this.diam);
            } else if (n == 49) {
                if (this.catchX > this.moveRight && this.catchY > this.moveDown) {
                    if (this.doubleStep) {
                        this.catchX -= 2 * this.step;
                        this.catchY -= 2 * this.step;
                        this.doubleStep = false;
                    } else {
                        this.catchX -= this.step;
                        this.catchY -= this.step;
                    }
                    if (this.catchX < this.moveRight) {
                        this.catchX = this.moveRight + 1;
                    }
                    if (this.catchY < this.moveDown) {
                        this.catchY = this.moveDown + 1;
                    }
                }
            } else if (n == 51) {
                if (this.catchY > this.moveDown && this.catchX < this.moveRight + this.width - this.diam) {
                    if (this.doubleStep) {
                        this.catchY -= 2 * this.step;
                        this.catchX += 2 * this.step;
                        this.doubleStep = false;
                    } else {
                        this.catchY -= this.step;
                        this.catchX += this.step;
                    }
                    if (this.catchY < this.moveDown) {
                        this.catchY = this.moveDown + 1;
                    }
                    if (this.catchX > this.moveRight + this.width - this.diam) {
                        this.catchX = this.moveRight + this.width - this.diam - 1;
                    }
                }
            } else if (n == 55) {
                if (this.catchX > this.moveRight && this.catchY < this.moveDown + this.height - this.diam + 5) {
                    if (this.doubleStep) {
                        this.catchX -= 2 * this.step;
                        this.catchY += 2 * this.step;
                        this.doubleStep = false;
                    } else {
                        this.catchX -= this.step;
                        this.catchY += this.step;
                    }
                    if (this.catchX < this.moveRight) {
                        this.catchX = this.moveRight + 1;
                    }
                    if (this.catchY > this.moveDown + this.height - this.diam) {
                        this.catchY = this.moveDown + this.height - this.diam - 1;
                    }
                }
            } else if (n == 57 && this.catchY < this.moveDown + this.height - this.diam + 5 && this.catchX < this.moveRight + this.width - this.diam) {
                if (this.doubleStep) {
                    this.catchY += 2 * this.step;
                    this.catchX += 2 * this.step;
                    this.doubleStep = false;
                } else {
                    this.catchY += this.step;
                    this.catchX += 2 * this.step;
                }
                if (this.catchY > this.moveDown + this.height - this.diam) {
                    this.catchY = this.moveDown + this.height - this.diam - 1;
                }
                if (this.catchX > this.moveRight + this.width - this.diam) {
                    this.catchX = this.moveRight + this.width - this.diam - 1;
                }
            }
        }
    }

    void setScore(int n) {
        if (n > 0) {
            if (this.sound) {
                this.soundsEngine.playBzz(n);
            }
            this.afterNewStage = false;
            ++this.numBugsCaught;
            this.score += n;
            ++this.oneAfterAnother;
            switch (this.oneAfterAnother) {
                case 10: {
                    this.score += 10;
                    break;
                }
                case 20: {
                    this.score += 20;
                    break;
                }
                case 30: {
                    this.score += 30;
                    break;
                }
                case 40: {
                    this.score += 40;
                    break;
                }
                case 50: {
                    this.score += 50;
                    break;
                }
                case 60: {
                    this.score += 60;
                    break;
                }
                case 70: {
                    this.score += 70;
                    break;
                }
                case 80: {
                    this.score += 80;
                    break;
                }
                case 90: {
                    this.score += 90;
                    break;
                }
                case 100: {
                    this.score += 1000;
                    this.oneAfterAnother = 0;
                }
            }
        } else {
            ++this.missed;
            this.oneAfterAnother = 0;
            if (this.missed >= 10) {
                this.missed = 0;
                --this.lives;
                if (this.sound) {
                    this.soundsEngine.playMissedLife();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHighestScore() {
        if (this.score > BugzBuster.highScores[this.level - 1]) {
            BugzBuster.highScores[this.level - 1] = this.score;
            RecordStore recordStore = null;
            byte[] byArray = new byte[3];
            try {
                recordStore = RecordStore.openRecordStore((String)"highScores", (boolean)false);
                byArray = BugzBuster.calcScore(this.score);
                recordStore.setRecord(this.level, byArray, 0, 3);
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {}
            }
            return true;
        }
        return false;
    }

    private void checkIfGameIsOver() {
        if (this.lives < 1) {
            this.stopAnimation();
            this.firstTime = true;
            this.resultStr = this.isHighestScore() ? "Congratulations!\nBest result!!!\nYour score is " + this.score + "!" + "\nYou caught " + this.numBugsCaught + " bugs and reached stage " + this.stage + "!" : "You reached stage " + this.stage + ".\nYou caught " + this.numBugsCaught + " bugs and your score is " + this.score + "!";
            this.gameOverAlert.setString(this.resultStr);
            this.gameOverAlert.setTimeout(-2);
            this.midlet.mainList.delete(0);
            this.midlet.currentDisplayable = this.midlet.mainList;
            this.midlet.display.setCurrent(this.gameOverAlert, this.midlet.currentDisplayable);
        } else if (this.score >= 1000000) {
            this.stopAnimation();
            this.firstTime = true;
            this.isHighestScore();
            this.million = true;
            this.resultStr = "Congratulations!!!\nYou are the best!\nYou caught million bugs and won the game!";
            this.gameOverAlert.setString(this.resultStr);
            this.gameOverAlert.setTimeout(-2);
            this.midlet.mainList.delete(0);
            this.midlet.currentDisplayable = this.midlet.mainList;
            this.midlet.display.setCurrent(this.gameOverAlert, this.midlet.currentDisplayable);
        } else if (!this.afterNewStage && this.numBugsCaught > 0 && this.numBugsCaught % 50 == 0) {
            this.afterNewStage = true;
            this.pauseAnimation();
            ++this.lives;
            ++this.stage;
            if (this.delay > 9) {
                this.delay -= 10;
            }
            if (this.repaintDelay > 0) {
                --this.repaintDelay;
            }
            this.bNewStageAlert = true;
            this.hideTimes = 0;
            this.explosionEngine.init();
            this.resultStr = "Congratulations!!!\nYou caught " + this.numBugsCaught + " bugs and reached stage " + this.stage + "!!!\nYour score is " + this.score + " and you get a new life!";
            this.newStageAlert.setString(this.resultStr);
            this.newStageAlert.setTimeout(-2);
            this.midlet.display.setCurrent(this.newStageAlert, this.midlet.currentDisplayable);
        }
    }
}

