/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class BugzBuster
extends MIDlet
implements CommandListener {
    static final boolean DEBUG = false;
    static final boolean NETWORK = false;
    static final boolean REAL_DEVICE = true;
    static StringBuffer testSB = new StringBuffer();
    Display display;
    Displayable currentDisplayable;
    private Form loadingForm;
    private Form helpForm;
    private Form aboutForm;
    private SplashCanvas splashCanvas;
    private BugsCanvas bugsCanvas;
    private Thread thread;
    private Gauge gauge;
    private int iGauge;
    private Command helpCommand;
    private Command okCommand;
    private Command exitCommand;
    private Command aboutCommand;
    private Command backCommand;
    private Command nextCommand;
    private Command soundOnCommand;
    private Command soundOffCommand;
    private Command pauseCommand;
    private Command resumeCommand;
    private Form emailForm;
    private TextField emailTF;
    private String sEmail;
    private String sCode;
    private int iCode;
    private Form confirmForm;
    List mainList;
    List levelList;
    private String[] mainStr = new String[]{"New game", "High scores", "Turn sound off", "Help", "About", "Exit"};
    private byte level = 1;
    public static int[] highScores = new int[5];
    Image[][] bugsImg;
    Image[] expImg;
    Image splashImg;
    Image backBelow;
    Image backOver;
    final String APP_VERSION = "version " + this.getAppProperty("MIDlet-Version");
    final String APP_NAME = this.getAppProperty("MIDlet-Name");
    final String APP_SPLASH;
    final String MAIN_STR = this.getAppProperty("MIDlet-Description");
    final String ABOUT_STR = this.APP_NAME + ", version " + this.getAppProperty("MIDlet-Version") + "\nCopyright 2003 Zindell Technologies, Ltd. All rights reserved. Developed by " + this.getAppProperty("MIDlet-Vendor") + " " + this.getAppProperty("MIDlet-Info-URL") + "\nSoftware is provided \"AS IS\" without warranty of any kind. In no event, shall we be liable for any claim, damages or other liability.";
    final String HELP_STR;

    public BugzBuster() {
        this.APP_SPLASH = "/BugsSplash.png";
        this.HELP_STR = "Try to catch as many bugs as possible and reach maximum score of 1000000 points. Move the joystick or press Numeric keys to control the bugs catcher. Press '2' to move up, '8' to move down, '4' to move left, '6' to move right. Press '1', '3', '7' or '9' to move diagonally. Press the joystick or '5' to shoot the bug. Each bug caught adds a point or more to your score. Beware of the bugs that hide behind the leaves! You get extra points if you catch bugs that move faster than others. After each 50 bugs caught you proceed to a new stage and the speed of the game increases. For further assistance please send us an e-mail to BugzBuster@jacado.com.";
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.mainList) {
            if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("New game")) {
                if (this.mainList.size() == this.mainStr.length) {
                    this.mainList.insert(0, "Continue", null);
                }
                this.bugsCanvas.init();
                this.currentDisplayable = this.bugsCanvas;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Continue")) {
                this.bugsCanvas.resumeAnimation();
                this.currentDisplayable = this.bugsCanvas;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("High scores")) {
                String string = "";
                int n = 1;
                while (n < 6) {
                    string = string + highScores[n - 1] + " points";
                    if (n < 5) {
                        string = string + "\n";
                    }
                    ++n;
                }
                Alert alert = null;
                alert = this.bugsCanvas.sound ? new Alert("High scores", string, this.bugsImg[1][0], AlertType.INFO) : new Alert("High scores", string, this.bugsImg[1][0], null);
                alert.setTimeout(-2);
                this.display.setCurrent(alert, (Displayable)this.mainList);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Turn sound off")) {
                this.bugsCanvas.sound = false;
                if (this.mainList.size() == this.mainStr.length) {
                    this.mainList.set(2, "Turn sound on", null);
                } else {
                    this.mainList.set(3, "Turn sound on", null);
                }
                this.currentDisplayable = this.mainList;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Turn sound on")) {
                this.bugsCanvas.sound = true;
                if (this.mainList.size() == this.mainStr.length) {
                    this.mainList.set(2, "Turn sound off", null);
                } else {
                    this.mainList.set(3, "Turn sound off", null);
                }
                this.currentDisplayable = this.mainList;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Help")) {
                this.currentDisplayable = this.helpForm;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("About")) {
                this.currentDisplayable = this.aboutForm;
                this.display.setCurrent(this.currentDisplayable);
            } else if (this.mainList.getString(this.mainList.getSelectedIndex()).equals("Exit")) {
                if (displayable == this.bugsCanvas) {
                    this.bugsCanvas.exit = true;
                    this.bugsCanvas.stopAnimation();
                }
                this.exit();
            }
        } else if (displayable == this.helpForm || displayable == this.aboutForm || displayable == this.levelList) {
            this.currentDisplayable = this.mainList;
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void startApp() {
        if (this.display == null) {
            this.thread = new Thread(){

                public void run() {
                    try {
                        BugzBuster.this.display = Display.getDisplay((MIDlet)BugzBuster.this);
                        BugzBuster.this.loadingForm = new Form("Loading...");
                        BugzBuster.this.currentDisplayable = BugzBuster.this.loadingForm;
                        BugzBuster.this.gauge = new Gauge("Please wait", false, 10, 0);
                        BugzBuster.this.loadingForm.append((Item)BugzBuster.this.gauge);
                        BugzBuster.this.gauge.setValue(0);
                        BugzBuster.this.display.setCurrent((Displayable)BugzBuster.this.loadingForm);
                        BugzBuster.this.nextCommand = new Command("Next", 4, 4);
                        BugzBuster.this.okCommand = new Command("OK", 4, 4);
                        BugzBuster.this.backCommand = new Command("Back", 2, 2);
                        BugzBuster.this.loadHighScore();
                        BugzBuster.this.iGauge = 0;
                        BugzBuster.this.gauge.setValue(++BugzBuster.this.iGauge);
                        BugzBuster.this.mainList = new List(BugzBuster.this.APP_NAME, 3, BugzBuster.this.mainStr, null);
                        BugzBuster.this.mainList.setCommandListener((CommandListener)BugzBuster.this);
                        BugzBuster.this.gauge.setValue(++BugzBuster.this.iGauge);
                        BugzBuster.this.splashImg = Image.createImage((String)"/BugsSplash.png");
                        BugzBuster.this.gauge.setValue(++BugzBuster.this.iGauge);
                        BugzBuster.this.backBelow = Image.createImage((String)"/backBelow.png");
                        BugzBuster.this.backOver = Image.createImage((String)"/backOver.png");
                        BugzBuster.this.gauge.setValue(++BugzBuster.this.iGauge);
                        BugzBuster.this.expImg = new Image[15];
                        int n = 0;
                        while (n < BugzBuster.this.expImg.length) {
                            BugzBuster.this.expImg[n] = Image.createImage((String)("/e" + n + ".png"));
                            ++n;
                        }
                        BugzBuster.this.bugsImg = new Image[5][2];
                        int n2 = 0;
                        while (n2 < BugzBuster.this.bugsImg.length) {
                            int n3 = 0;
                            while (n3 < 2) {
                                BugzBuster.this.bugsImg[n2][n3] = Image.createImage((String)("/b" + n2 + "" + n3 + ".png"));
                                ++n3;
                            }
                            BugzBuster.this.gauge.setValue(++BugzBuster.this.iGauge);
                            ++n2;
                        }
                        BugzBuster.this.bugsCanvas = new BugsCanvas(BugzBuster.this);
                        BugzBuster.this.gauge.setValue(++BugzBuster.this.iGauge);
                        BugzBuster.this.aboutForm = new Form("About");
                        BugzBuster.this.aboutForm.append(BugzBuster.this.ABOUT_STR);
                        BugzBuster.this.aboutForm.addCommand(BugzBuster.this.backCommand);
                        BugzBuster.this.aboutForm.setCommandListener((CommandListener)BugzBuster.this);
                        BugzBuster.this.helpForm = new Form("Help");
                        BugzBuster.this.helpForm.append("Try to catch as many bugs as possible and reach maximum score of 1000000 points. Move the joystick or press Numeric keys to control the bugs catcher. Press '2' to move up, '8' to move down, '4' to move left, '6' to move right. Press '1', '3', '7' or '9' to move diagonally. Press the joystick or '5' to shoot the bug. Each bug caught adds a point or more to your score. Beware of the bugs that hide behind the leaves! You get extra points if you catch bugs that move faster than others. After each 50 bugs caught you proceed to a new stage and the speed of the game increases. For further assistance please send us an e-mail to BugzBuster@jacado.com.");
                        BugzBuster.this.helpForm.addCommand(BugzBuster.this.backCommand);
                        BugzBuster.this.helpForm.setCommandListener((CommandListener)BugzBuster.this);
                        BugzBuster.this.gauge.setValue(++BugzBuster.this.iGauge);
                        BugzBuster.this.currentDisplayable = BugzBuster.this.mainList;
                        BugzBuster.this.splashCanvas = new SplashCanvas();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            this.thread.start();
        } else {
            System.gc();
            this.display.setCurrent(this.currentDisplayable);
        }
    }

    public void pauseApp() {
        if (this.currentDisplayable != this.mainList) {
            if (this.currentDisplayable == this.bugsCanvas) {
                this.bugsCanvas.pauseAnimation();
                System.gc();
                this.currentDisplayable = this.mainList;
            } else {
                this.currentDisplayable = this.display.getCurrent();
            }
        }
    }

    public void exit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void destroyApp(boolean bl) {
        this.display = null;
        this.currentDisplayable = null;
        this.helpForm = null;
        this.aboutForm = null;
        this.mainList = null;
        this.loadingForm = null;
        this.gauge = null;
        this.helpCommand = null;
        this.nextCommand = null;
        this.okCommand = null;
        this.exitCommand = null;
        this.backCommand = null;
        this.aboutCommand = null;
        this.bugsCanvas = null;
        this.splashCanvas = null;
        this.thread = null;
    }

    static byte[] calcScore(int n) {
        byte[] byArray = new byte[]{(byte)(n / 10000), (byte)(n % 10000 / 100), (byte)(n % 100)};
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHighScore() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"highScores", (boolean)true);
            if (recordStore.getNumRecords() == 5) {
                int n = 1;
                while (n < 6) {
                    byte[] byArray = recordStore.getRecord(n);
                    BugzBuster.highScores[n - 1] = byArray[0] * 10000 + byArray[1] * 100 + byArray[2];
                    ++n;
                }
            } else {
                if (recordStore.getNumRecords() > 0) {
                    this.deleteScoresDatabase();
                }
                recordStore = RecordStore.openRecordStore((String)"highScores", (boolean)true);
                int n = 1;
                while (n < 6) {
                    byte[] byArray = BugzBuster.calcScore(0);
                    recordStore.addRecord(byArray, 0, 3);
                    BugzBuster.highScores[n - 1] = 0;
                    ++n;
                }
            }
        }
        catch (RecordStoreException recordStoreException) {
            this.deleteScoresDatabase();
            recordStoreException.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {}
        }
    }

    private void deleteScoresDatabase() {
        try {
            RecordStore.deleteRecordStore((String)"highScores");
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    private Displayable getEmailForm() {
        if (this.emailForm == null) {
            this.emailForm = new Form("Bugs King");
            this.emailTF = new TextField("Please enter your e-mail", "", 30, 1);
            this.emailForm.append((Item)this.emailTF);
            this.emailForm.setCommandListener((CommandListener)this);
            this.emailForm.addCommand(this.nextCommand);
        }
        this.emailTF.setString("");
        return this.emailForm;
    }

    public void networkResponse(String string) {
        Alert alert = new Alert("Bugs King", string, this.bugsImg[1][0], null);
        alert.setTimeout(-2);
        this.display.setCurrent(alert, (Displayable)this.mainList);
    }

    private Displayable getConfirmForm(String string) {
        if (this.confirmForm == null) {
            this.confirmForm = new Form("Bugs King");
            this.confirmForm.setCommandListener((CommandListener)this);
        }
        if (this.confirmForm.size() > 0) {
            this.confirmForm.delete(0);
        }
        this.confirmForm.removeCommand(this.nextCommand);
        this.confirmForm.removeCommand(this.backCommand);
        if (string.equals("")) {
            this.confirmForm.append("Please enter your e-mail before you proceed.");
            this.confirmForm.addCommand(this.backCommand);
        } else {
            this.confirmForm.append("You entered the following e-mail:\n" + string + "\nPress NEXT to proceed or BACK to change the e-mail.");
            this.confirmForm.addCommand(this.nextCommand);
            this.confirmForm.addCommand(this.backCommand);
        }
        return this.confirmForm;
    }

    private class SplashCanvas
    extends FullCanvas {
        private Timer timer = new Timer();
        private int width;
        private int height;
        private Font bigFont;
        private Font smallFont;

        private SplashCanvas() {
            try {
                BugzBuster.this.splashImg = Image.createImage((String)"/BugsSplash.png");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            BugzBuster.this.display.setCurrent((Displayable)this);
        }

        protected void showNotify() {
            this.timer.schedule((TimerTask)new CountDown(), 3000L);
        }

        protected void keyPressed(int n) {
            this.dismiss();
        }

        protected void pointerPressed(int n, int n2) {
            this.dismiss();
        }

        protected void paint(Graphics graphics) {
            if (BugzBuster.this.backBelow == null || BugzBuster.this.backOver == null) {
                graphics.setColor(0, 0, 180);
                graphics.fillRect(0, 0, 176, 208);
            } else {
                graphics.drawImage(BugzBuster.this.backBelow, 0, 0, 20);
                graphics.drawImage(BugzBuster.this.backOver, 0, 0, 20);
                if (BugzBuster.this.splashImg == null) {
                    graphics.setColor(160, 0, 0);
                    graphics.setFont(this.bigFont);
                    graphics.drawString(BugzBuster.this.APP_NAME.toUpperCase(), 88, 94, 33);
                    graphics.setFont(this.smallFont);
                    graphics.drawString(BugzBuster.this.APP_VERSION, 88, 114, 17);
                } else {
                    graphics.drawImage(BugzBuster.this.splashImg, 88, 104, 3);
                }
            }
        }

        private void dismiss() {
            this.timer.cancel();
            BugzBuster.this.currentDisplayable = BugzBuster.this.mainList;
            BugzBuster.this.display.setCurrent(BugzBuster.this.currentDisplayable);
        }

        private class CountDown
        extends TimerTask {
            private CountDown() {
            }

            public void run() {
                SplashCanvas.this.dismiss();
            }
        }
    }
}

