/*
 * Decompiled with CFR 0.152.
 */
package ys.pingu;

import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ys.pingu.PinguMIDlet;
import ys.pingu.PinguScores;

class PinguHigh
extends Canvas
implements CommandListener {
    private final PinguMIDlet parent;
    private final Command backCommand;
    private final Font fNorm = Font.getFont((int)0, (int)0, (int)8);
    private final Font fBold = Font.getFont((int)0, (int)1, (int)0);
    private final int spacingPara;
    private final int spacing;
    private final int fHNorm = this.fNorm.getHeight();
    private final int fHBold = this.fBold.getHeight();
    private Image currentFrame;
    private Graphics gc;
    private int updown;
    private int imageWidth;
    private int imageHeight;
    private int offsetY = 0;

    PinguHigh(PinguMIDlet parent) {
        this.spacingPara = 7;
        this.spacing = 3;
        this.parent = parent;
        this.updown = 0;
        this.imageWidth = this.getWidth();
        this.imageHeight = 5 * (this.fHBold + this.fHNorm + 7 + 3);
        this.currentFrame = Image.createImage((int)this.imageWidth, (int)this.imageHeight);
        this.gc = this.currentFrame.getGraphics();
        this.backCommand = new Command("Back", 2, 1);
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    public void init() {
        this.updown = 0;
    }

    private void drawScore(int i, int v) {
        String sV = " " + v / 10 + "." + v % 10 + " ";
        this.gc.setFont(this.fBold);
        this.gc.drawString(PinguScores.getScoreName(i), this.imageWidth / 2, this.offsetY, 17);
        this.offsetY += this.fHBold + 3;
        this.gc.setFont(this.fNorm);
        this.gc.drawString(sV, this.imageWidth / 2, this.offsetY, 17);
        this.offsetY += this.fHNorm + 7;
    }

    private void updateScores() {
        this.gc.setColor(0xFFFFFF);
        this.gc.fillRect(0, 0, this.imageWidth, this.imageHeight);
        this.gc.setColor(0);
        this.offsetY = 0;
        int i = 0;
        while (i < 5) {
            int v = PinguScores.getScore(i);
            if (v > 0) {
                this.drawScore(i, v);
            }
            ++i;
        }
    }

    protected void paint(Graphics g) {
        this.updateScores();
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        if (this.currentFrame != null) {
            g.drawImage(this.currentFrame, 0, this.updown, 20);
        }
    }

    public void commandAction(Command c, Displayable d) {
        this.parent.pinguHighBack();
    }

    protected void keyPressed(int keyCode) {
        if (this.getGameAction(keyCode) == 6) {
            int dy = this.imageHeight - this.getHeight();
            if (dy > 0 && this.updown > dy * -1) {
                this.updown -= 10;
            }
            this.repaint();
        }
        if (this.getGameAction(keyCode) == 1) {
            if (this.updown < 0) {
                this.updown += 10;
            }
            this.repaint();
        }
    }
}

