/*
 * Decompiled with CFR 0.152.
 */
package com.bluebeck.mobile.framework;

import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public abstract class MobileCanvas
extends FullCanvas
implements Runnable {
    private MIDlet parent;
    private volatile Thread animationThread = null;
    public static int canvasWidth;
    public static int canvasHeight;
    public boolean gameSound = false;
    long inactivityTimer = 0L;
    boolean inactivityTimerStarted = false;
    int inactivityTimerDelay = 10000;
    int timePerFrame = 55;
    long gameTimer = 0L;
    long gameTimerMillis = 0L;
    long gameTimerSeconds = 0L;
    long gameTimerMinutes = 0L;
    long gameTimerHours = 0L;
    boolean gameTimerStarted = false;
    public boolean paused = false;
    long startTime = 0L;
    int viewStartX = -26;
    int viewStartY = -26;
    int factor = 10;
    public boolean freeze = false;

    public MobileCanvas() {
        this.startGameTimer();
        canvasWidth = this.getWidth();
        canvasHeight = this.getHeight();
    }

    public synchronized void start() {
        if (this.animationThread == null) {
            this.animationThread = new Thread(this);
            this.animationThread.start();
        } else {
            this.freeze = false;
        }
    }

    public void hideNotify() {
        this.paused = true;
        this.freeze = true;
    }

    public void showNotify() {
        this.freeze = false;
    }

    public void forceRepaint() {
        this.serviceRepaints();
        this.repaint();
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                if (this.freeze) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        this.parent.notifyDestroyed();
                        return;
                    }
                }
                this.startTime = System.currentTimeMillis();
                this.checkInactivityTimer();
                this.gameLoop();
                this.repaint();
                this.serviceRepaints();
                long timeTaken = System.currentTimeMillis() - this.startTime;
                if (timeTaken < (long)this.timePerFrame) {
                    Thread.sleep((long)this.timePerFrame - timeTaken);
                    continue;
                }
                Thread.yield();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public abstract void gameLoop();

    public abstract void paint(Graphics var1);

    void checkInactivityTimer() {
        if (!this.inactivityTimerStarted) {
            this.inactivityTimerStarted = true;
            this.inactivityTimer = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.inactivityTimer > (long)this.inactivityTimerDelay) {
            this.inactivityTimer = System.currentTimeMillis();
            this.handleInactivityTimer();
        }
    }

    public abstract void handleInactivityTimer();

    void startGameTimer() {
        this.gameTimerStarted = true;
        this.gameTimer = System.currentTimeMillis();
    }

    public abstract void keyPressed(int var1);

    public abstract void keyReleased(int var1);
}

