/*
 * Decompiled with CFR 0.152.
 */
package com.bluebeck.mobile.popidol;

import com.bluebeck.mobile.framework.MobileCanvas;
import com.bluebeck.mobile.framework.MobileSprite;
import com.bluebeck.mobile.popidol.Bottle;
import com.bluebeck.mobile.popidol.Bucket;
import com.bluebeck.mobile.popidol.Fan;
import com.bluebeck.mobile.popidol.ThrownBottle;
import javax.microedition.lcdui.Image;

public class Bouncer
extends MobileSprite {
    private int centre_facingRight = 13;
    private int centre_facingLeft = 25;
    public int pointMultiplier = 1;
    public int speedMultiplier = 1;
    public boolean pushPowerup = false;
    public int currentPowerup = -1;
    int pickupTimer = 0;
    int maxPickupTime = 200;
    protected int[][] animation = new int[][]{{0, 1, 2, 3, 4, 1}, {5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 1}, {11, 12, 13, 14, 15, 15, 15, 15, 16, 1}, {17, 18, 19, 20, 21, 22, 3}, {17, 18, 19, 20, 21, 22, 4}, {23, 24, 25, 26, 26, 26, 26, 26, 26, 25, 24, 23, 1}, {27, 7}, {28, 29, 30, 31, 31, 31, 31, 31, 31, 32, 32, 1}, {35, 35, 35, 35, 35, 34, 33, 1}};

    public boolean moveLeft(int aAmount) {
        if (this.animState != 4) {
            this.changeAnim(4, true, true, true, this.animation);
            this.vx = -4;
            this.drawFlipped = true;
        }
        return true;
    }

    public void startListen() {
        if (this.animState == 1 && this.animState != 5) {
            this.changeAnim(5, true, true, true, this.animation);
            this.vx = 0;
        }
    }

    public void resetPickups() {
        this.pickupTimer = -1;
        this.speedMultiplier = 1;
        this.pointMultiplier = 1;
        this.pushPowerup = false;
        this.currentPowerup = -1;
    }

    public void reset() {
        super.reset();
        this.resetPickups();
    }

    public void checkPickups(Bottle bot, ThrownBottle tb) {
        int bouncerCentreX = this.x + (this.drawFlipped ? this.centre_facingLeft : this.centre_facingRight);
        if (Math.abs(bouncerCentreX - (bot.x + bot.frameWidth / 2)) < 15 && bot.animState != 65535) {
            this.resetPickups();
            this.pickupTimer = 0;
            this.currentPowerup = bot.animState;
            switch (this.currentPowerup) {
                case 0: {
                    this.pushPowerup = true;
                    this.maxPickupTime = 100;
                    break;
                }
                case 1: {
                    this.pointMultiplier = 2;
                    this.maxPickupTime = 150;
                    break;
                }
                case 2: {
                    this.speedMultiplier = 2;
                    this.maxPickupTime = 200;
                }
            }
            bot.startPickup();
        }
        if (Math.abs(bouncerCentreX - (tb.x + tb.frameWidth / 2)) < 10) {
            if (tb.animState == 2 && this.y - (tb.y + tb.frameHeight / 2) < 15) {
                tb.startDrop();
                this.stop();
                this.changeAnim(8, true, true, true, this.animation);
            }
        }
    }

    public int firePressed(Fan[] f, Bucket b) {
        int bouncerCentreX = this.x + (this.drawFlipped ? this.centre_facingLeft : this.centre_facingRight);
        if (Math.abs(bouncerCentreX - (b.x + b.frameWidth / 2)) < 15 && b.animState != 65535) {
            this.changeAnim(6, true, true, true, this.animation);
            if (Bucket.position == 5) {
                this.drawFlipped = true;
            }
            b.startPickup();
            this.vx = 0;
            return 7;
        }
        int i = 0;
        while (i < f.length) {
            int fanCentreX;
            Fan fan = f[i];
            int fanAnimState = fan.animState;
            if (fanAnimState != 65535 && Math.abs(bouncerCentreX - (fanCentreX = fan.x + fan.frameWidth / 2)) < 13) {
                if (fan.isClimbing() && !this.pushPowerup) {
                    this.changeAnim(0, true, true, true, this.animation);
                    this.vx = 0;
                    fan.startPush();
                    return 0;
                }
                if (!fan.isClimbing() && !fan.isFalling()) {
                    if (!this.pushPowerup) {
                        this.changeAnim(2, true, true, true, this.animation);
                        this.vx = 0;
                    }
                    if (bouncerCentreX < fanCentreX) {
                        if (!this.pushPowerup) {
                            this.drawFlipped = true;
                        }
                        fan.startThrow(2);
                    } else {
                        fan.startThrow(5);
                    }
                    return 2;
                }
            }
            ++i;
        }
        return 65535;
    }

    public boolean moveRight(int aAmount) {
        if (this.animState != 3) {
            this.changeAnim(3, true, true, true, this.animation);
            this.vx = 4;
            this.drawFlipped = false;
        }
        return false;
    }

    public void stop() {
        this.changeAnim(1, true, true, true, this.animation);
        this.vx = 0;
        this.vy = 0;
        this.drawFlipped = false;
    }

    public void doAnim() {
        if (this.animState != 65535) {
            if (this.x + this.frameWidth / 2 > MobileCanvas.canvasWidth) {
                this.x = MobileCanvas.canvasWidth - this.frameWidth / 2;
                this.vx = 0;
                this.changeAnim(1, true, true, true, this.animation);
            } else if (this.x < -(this.frameWidth / 2)) {
                this.x = -(this.frameWidth / 2);
                this.vx = 0;
                this.changeAnim(1, true, true, true, this.animation);
            }
            this.updateAnim(this.animation);
            this.x += this.vx * this.speedMultiplier;
            this.y += this.vy * this.speedMultiplier;
            if (this.pickupTimer > this.maxPickupTime) {
                this.resetPickups();
            } else if (this.pickupTimer > -1) {
                ++this.pickupTimer;
            }
        }
    }

    public Bouncer(Image aImageStrip, int aNumFrames) {
        super(aImageStrip, aNumFrames);
        this.changeAnim(1, true, true, true, this.animation);
        this.framesSpeed = 0;
    }
}

